# Online Meta Constrained Imitation Learning

This code is for online constrained meta-learning in dynamic environments, which includes 2 types of dynamic environments (abruptly changing environment and gradually evolving environment) and 3 kinds of algorithms (FTPL, FTPL-D+, FTPL-A).

## Prerequisites
 - Python 3.9.12
 - Pytorch 2.3.0
 - Numpy 1.19.2

## Usage

### Train

Run 
```
cd ./online_constrained_meta_learning/[ENVIRONMENT]/[METHOD]
python ./meta-learning.py
```

For example, run our method FTPL-D+ in abruptly changing environments:
```
cd ./online_constrained_meta_learning/abruptly_changing/FTPL-D+
python ./meta-learning.py
```

### Test

Run 
```
python ./online_adaptation_test.py
```


## Acknowledgment
Thanks for the code framework provided by Siyuan Xu and Minghui Zhu. Here is their work:
```
@inproceedings{xu2023online,
  title={Online Constrained Meta-Learning: Provable Guarantees for Generalization},
  author={Xu, Siyuan and Zhu, Minghui},
  booktitle={Advance in Neural Information Processing Systems},
  volume={37},
  year={2023}
}
```